locals {
  istio_ingressgateway    = "ingressgateway"
  istio_ingress_namespace = "istio-ingress"
  istio_system_namespace  = "istio-system"

  http_port_name = "http"
}

resource "helm_release" "metrics_server" {
  name            = "metrics-server"
  chart           = format("./%s/helm/metrics-server-3.10.0", path.root)
  timeout         = 300
  cleanup_on_fail = true
  force_update    = true
  namespace       = "kube-system"
}

resource "kubernetes_namespace" "istio_system" {
  depends_on = [helm_release.metrics_server]

  metadata {
	name = local.istio_system_namespace
  }
}

resource "kubernetes_namespace" "istio_ingress" {
  depends_on = [helm_release.metrics_server]

  metadata {
	name = local.istio_ingress_namespace
  }
}

resource "helm_release" "istio_base" {
  depends_on = [kubernetes_namespace.istio_system]

  name            = "istio-base"
  chart           = format("./%s/helm/istio-1.17.2/charts/base", path.root)
  timeout         = 120
  cleanup_on_fail = true
  force_update    = false
  namespace       = local.istio_system_namespace
}

resource "helm_release" "istiod" {
  depends_on = [helm_release.istio_base]

  name            = "istiod"
  chart           = format("./%s/helm/istio-1.17.2/charts/istio-control/istio-discovery", path.root)
  timeout         = 120
  cleanup_on_fail = true
  force_update    = false
  namespace       = local.istio_system_namespace
}

resource "helm_release" "istio_gateway" {
  depends_on = [
	kubernetes_namespace.istio_ingress,
	helm_release.istiod,
  ]

  name            = "istio-ingressgateway"
  chart           = format("./%s/helm/istio-1.17.2/charts/gateway", path.root)
  timeout         = 300
  cleanup_on_fail = true
  force_update    = false
  namespace       = local.istio_ingress_namespace
}
