locals {
  zone = "dev.localhost"
}

resource "kubernetes_manifest" "gateway" {
  depends_on = [helm_release.istio_gateway]

  manifest = {
	apiVersion = "networking.istio.io/v1beta1"
	kind       = "Gateway"
	metadata   = {
	  name      = "gateway"
	  namespace = "default"
	}
	spec = {
	  selector = {
		istio = local.istio_ingressgateway
	  }
	  servers = [
		{
		  hosts = [local.zone, format("*.%s", local.zone)]
		  port  = {
			name     = "http2"
			number   = 80
			protocol = "HTTP2"
		  }
		}
	  ]
	}
  }
}
